/*
 * Decompiled with CFR 0.152.
 */
package com.drawmetry.dociimentor.database;

import com.drawmetry.dociimentor.Configuration;
import com.drawmetry.dociimentor.DocEntry;
import com.drawmetry.dociimentor.DocumentObject;
import com.drawmetry.dociimentor.UI;
import com.sun.rowset.WebRowSetImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class DataAccessObject {
    private Connection dbConnection;
    private Properties dbProperties;
    private boolean isConnected;
    private String dbName;
    private PreparedStatement[] stmtSaveNewRecord;
    private PreparedStatement[] stmtUpdateExistingRecord;
    private PreparedStatement[] stmtGetListEntries;
    private PreparedStatement[] stmtFindEntries;
    private PreparedStatement[] stmtGetRecord;
    private PreparedStatement[] stmtDeleteRecord;
    private List<Statement> statements = new ArrayList<Statement>();
    private String[] tables = Configuration.getWorkingGroupTables();
    private static final ResourceBundle messageBundle = ResourceBundle.getBundle("com/drawmetry/dociimentor/resources/MessageBundle");
    private static final String ABNORMAL_SHUT_DOWN = messageBundle.getString("ABNORMAL SHUTDOWN");
    private static final String NORMAL_SHUT_DOWN = messageBundle.getString("NORMAL SHUTDOWN");
    private static final String strCreateDocumentTable = "create table %s (  ID           INTEGER NOT NULL PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), YEARVAR      INTEGER, DCN          INTEGER, REV          INTEGER, GROUPVAR     CHAR(4), TITLE        VARCHAR(150), AUTHORS      VARCHAR(400), UPLOADDATE   TIMESTAMP, URL          VARCHAR(300), FILENAME     VARCHAR(200), NOTES        VARCHAR(2000))";
    private static final String strGetRecord = "select * from %s where ID = ?";
    private static final String strSaveNewRecord = "insert into %s    (YEARVAR, DCN, REV, GROUPVAR, TITLE, AUTHORS, UPLOADDATE, URL, FILENAME, NOTES) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String strGetListEntries = "select ID, FILENAME from %s where FILENAME like ? order by FILENAME desc";
    private static final String strFindEntries = "select ID, FILENAME from %s where GROUPVAR like ? and LOWER(FILENAME) like ? and LOWER(AUTHORS) like ? and LOWER(NOTES) like ? and UPLOADDATE >= ? and UPLOADDATE <= ? order by FILENAME desc";
    private static final String strUpdateExistingRecord = "update %s set URL = ?,     TITLE = ?,     AUTHORS = ?,     NOTES = ?,     FILENAME = ?where ID = ?";
    private static final String strDeleteRecord = "delete from %s where ID = ?";

    public DataAccessObject() {
        this.dbProperties = this.loadDBProperties();
        this.setDBSystemDir();
        this.dbName = this.dbProperties.getProperty("db.name");
        String driverName = this.dbProperties.getProperty("derby.driver");
        this.loadDatabaseDriver(driverName);
        this.createDatabase();
    }

    public static void main(String[] args) {
        DataAccessObject db = new DataAccessObject();
        db.connect();
        try {
            Statement stmt = db.dbConnection.createStatement();
            ResultSet rs = stmt.executeQuery("select ID from WG80221 where UPLOADDATE <= '2010-01-01 00:00:00'");
            while (rs.next()) {
                int id = rs.getInt("ID");
                System.out.println("" + db.getFileOject("WG80221", id));
                db.deleteRecord("WG80221", id);
                db.dbConnection.commit();
            }
        }
        catch (SQLException ex) {
            UI.LOGGER.log(Level.SEVERE, null, ex);
        }
        db.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dump(String table, File toFile) {
        DataAccessObject db = new DataAccessObject();
        db.connect();
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(toFile));
            Statement statement = db.dbConnection.createStatement();
            ResultSet rs = statement.executeQuery("select * from " + table);
            WebRowSetImpl wrs = new WebRowSetImpl();
            wrs.populate(rs);
            wrs.writeXml(out);
            statement.close();
        }
        catch (IOException ex) {
        }
        catch (SQLException ex) {
            System.out.println("Error code = " + ex.getErrorCode());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        db.disconnect();
    }

    private boolean dbExists() {
        boolean bExists = false;
        String dbLocation = this.getDatabaseLocation();
        File dbFileDir = new File(dbLocation);
        if (dbFileDir.exists()) {
            bExists = true;
        }
        return bExists;
    }

    private void setDBSystemDir() {
        String systemDir = Configuration.getSystemHome().getAbsolutePath();
        System.setProperty("derby.system.home", systemDir);
    }

    private void loadDatabaseDriver(String driver) {
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            UI.LOGGER.log(Level.SEVERE, "Unable to load the JDBC driver {0}\nPlease check your CLASSPATH.\n", driver);
            cnfe.printStackTrace(System.err);
        }
        catch (InstantiationException ie) {
            UI.LOGGER.log(Level.SEVERE, "Unable to load the JDBC driver {0}\n", driver);
            ie.printStackTrace(System.err);
        }
        catch (IllegalAccessException iae) {
            UI.LOGGER.log(Level.SEVERE, "Not allowed to access the JDBC driver {0}\n", driver);
            iae.printStackTrace(System.err);
        }
    }

    private Properties loadDBProperties() {
        return Configuration.getProperties();
    }

    private boolean createTable(Connection conn, String table) {
        boolean bCreateTable = false;
        try {
            Statement stmtCreateTable = conn.createStatement();
            String strStmt = String.format(strCreateDocumentTable, table);
            stmtCreateTable.execute(strStmt);
            conn.commit();
            bCreateTable = true;
        }
        catch (SQLException ex) {
            DataAccessObject.printSQLException(ex);
        }
        return bCreateTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDatabase() {
        boolean bCreated = false;
        Connection dbCon = null;
        String dbUrl = this.getDatabaseUrl();
        if (!this.dbExists()) {
            this.dbProperties.put("create", "true");
        }
        try {
            dbCon = DriverManager.getConnection(dbUrl, this.dbProperties);
            DatabaseMetaData dmd = dbCon.getMetaData();
            for (String table : Configuration.getWorkingGroupTables()) {
                ResultSet rs = dmd.getTables(null, null, table, null);
                if (rs.next()) continue;
                this.createTable(dbCon, table);
            }
            bCreated = true;
        }
        catch (SQLException ex) {
            DataAccessObject.printSQLException(ex);
        }
        finally {
            try {
                if (dbCon != null) {
                    dbCon.close();
                }
            }
            catch (SQLException ex) {
                DataAccessObject.printSQLException(ex);
            }
        }
        return bCreated;
    }

    public boolean connect() {
        String dbUrl = this.getDatabaseUrl();
        try {
            this.dbConnection = DriverManager.getConnection(dbUrl, this.dbProperties);
            this.dbConnection.setAutoCommit(false);
            this.stmtSaveNewRecord = new PreparedStatement[this.tables.length];
            this.stmtUpdateExistingRecord = new PreparedStatement[this.tables.length];
            this.stmtGetRecord = new PreparedStatement[this.tables.length];
            this.stmtDeleteRecord = new PreparedStatement[this.tables.length];
            this.stmtGetListEntries = new PreparedStatement[this.tables.length];
            this.stmtFindEntries = new PreparedStatement[this.tables.length];
            for (int i = 0; i < this.tables.length; ++i) {
                String stmt = String.format(strSaveNewRecord, this.tables[i]);
                this.stmtSaveNewRecord[i] = this.dbConnection.prepareStatement(stmt, 1);
                this.statements.add(this.stmtSaveNewRecord[i]);
                stmt = String.format(strUpdateExistingRecord, this.tables[i]);
                this.stmtUpdateExistingRecord[i] = this.dbConnection.prepareStatement(stmt);
                this.statements.add(this.stmtUpdateExistingRecord[i]);
                stmt = String.format(strGetRecord, this.tables[i]);
                this.stmtGetRecord[i] = this.dbConnection.prepareStatement(stmt);
                this.statements.add(this.stmtGetRecord[i]);
                stmt = String.format(strDeleteRecord, this.tables[i]);
                this.stmtDeleteRecord[i] = this.dbConnection.prepareStatement(stmt);
                this.statements.add(this.stmtDeleteRecord[i]);
                stmt = String.format(strGetListEntries, this.tables[i]);
                this.stmtGetListEntries[i] = this.dbConnection.prepareStatement(stmt);
                this.statements.add(this.stmtGetListEntries[i]);
                stmt = String.format(strFindEntries, this.tables[i]);
                this.stmtFindEntries[i] = this.dbConnection.prepareStatement(stmt);
                this.statements.add(this.stmtFindEntries[i]);
            }
            this.isConnected = this.dbConnection != null;
        }
        catch (SQLException ex) {
            this.isConnected = false;
            DataAccessObject.printSQLException(ex);
        }
        return this.isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            String dbUrl = this.getDatabaseUrl();
            this.dbProperties.put("shutdown", "true");
            DriverManager.getConnection(dbUrl, this.dbProperties);
        }
        catch (SQLException se) {
            if (se.getErrorCode() == 45000 && "08006".equals(se.getSQLState())) {
                UI.LOGGER.log(Level.INFO, NORMAL_SHUT_DOWN, this.dbName);
            } else {
                UI.LOGGER.log(Level.INFO, ABNORMAL_SHUT_DOWN, this.dbName);
                DataAccessObject.printSQLException(se);
            }
        }
        finally {
            Iterator<Statement> i = this.statements.iterator();
            while (i.hasNext()) {
                Statement st = i.next();
                i.remove();
                try {
                    if (st == null) continue;
                    st.close();
                    st = null;
                }
                catch (SQLException sqle) {
                    DataAccessObject.printSQLException(sqle);
                }
            }
            try {
                if (this.dbConnection != null) {
                    this.dbConnection.close();
                    this.dbConnection = null;
                }
            }
            catch (SQLException sqle) {
                DataAccessObject.printSQLException(sqle);
            }
        }
    }

    public String getDatabaseLocation() {
        String dbLocation = System.getProperty("derby.system.home") + "/" + this.dbName;
        return dbLocation;
    }

    public String getDatabaseUrl() {
        String dbUrl = this.dbProperties.getProperty("derby.url") + this.dbName;
        return Configuration.getDerbyUrl() + Configuration.getDatabase();
    }

    public int saveRecord(String table, DocumentObject record) {
        int id = -1;
        int index = this.getTableIndex(table);
        try {
            this.stmtSaveNewRecord[index].clearParameters();
            this.stmtSaveNewRecord[index].setInt(1, record.getYear());
            this.stmtSaveNewRecord[index].setInt(2, record.getDcn());
            this.stmtSaveNewRecord[index].setInt(3, record.getRev());
            this.stmtSaveNewRecord[index].setString(4, record.getGroupCode());
            this.stmtSaveNewRecord[index].setString(5, record.getTitle());
            this.stmtSaveNewRecord[index].setString(6, record.getAuthors());
            this.stmtSaveNewRecord[index].setTimestamp(7, record.getUploadTimeStamp());
            this.stmtSaveNewRecord[index].setString(8, record.getURL().toString());
            this.stmtSaveNewRecord[index].setString(9, record.getFileName());
            this.stmtSaveNewRecord[index].setString(10, record.getNotes());
            this.dbConnection.commit();
            int rowCount = this.stmtSaveNewRecord[index].executeUpdate();
            ResultSet results = this.stmtSaveNewRecord[index].getGeneratedKeys();
            if (results.next()) {
                id = results.getInt(1);
            }
        }
        catch (SQLException sqle) {
            DataAccessObject.printSQLException(sqle);
        }
        return id;
    }

    public List<DocEntry> findEntries(String table, String group, String fileNme, String authors, String notes, Date uploadFrom, Date uploadTo) {
        ArrayList<DocEntry> listEntries = new ArrayList<DocEntry>();
        ResultSet results = null;
        int index = this.getTableIndex(table);
        try {
            this.stmtFindEntries[index].clearParameters();
            this.stmtFindEntries[index].setString(1, group);
            this.stmtFindEntries[index].setString(2, fileNme.toLowerCase());
            this.stmtFindEntries[index].setString(3, authors.toLowerCase());
            this.stmtFindEntries[index].setString(4, notes.toLowerCase());
            this.stmtFindEntries[index].setTimestamp(5, new Timestamp(uploadFrom.getTime()));
            this.stmtFindEntries[index].setTimestamp(6, new Timestamp(uploadTo.getTime()));
            results = this.stmtFindEntries[index].executeQuery();
            while (results.next()) {
                int id = results.getInt(1);
                String fileName = results.getString("FILENAME");
                DocEntry entry = new DocEntry(fileName, id);
                listEntries.add(entry);
            }
            this.dbConnection.commit();
        }
        catch (SQLException sqle) {
            DataAccessObject.printSQLException(sqle);
        }
        return listEntries;
    }

    public List<DocEntry> findEntries(String table, String fileName) {
        ArrayList<DocEntry> listEntries = new ArrayList<DocEntry>();
        ResultSet results = null;
        int index = this.getTableIndex(table);
        try {
            this.stmtGetListEntries[index].clearParameters();
            this.stmtGetListEntries[index].setString(1, fileName);
            results = this.stmtGetListEntries[index].executeQuery();
            while (results.next()) {
                int id = results.getInt(1);
                DocEntry entry = new DocEntry(results.getString(2), id);
                listEntries.add(entry);
            }
            this.dbConnection.commit();
        }
        catch (SQLException sqle) {
            DataAccessObject.printSQLException(sqle);
        }
        return listEntries;
    }

    public List<DocEntry> findEntries(String table, String yearStr, String groupCode) {
        ArrayList<DocEntry> listEntries = null;
        int year = 0;
        if (yearStr != null) {
            try {
                year = Integer.parseInt(yearStr);
            }
            catch (NumberFormatException ex) {
                yearStr = null;
            }
        }
        String stmtStr = yearStr == null ? (groupCode == null ? "select ID, FILENAME from " + table + " order by FILENAME desc" : "select ID, FILENAME from " + table + " where GROUPVAR like '" + groupCode + "'" + " order by FILENAME desc") : (groupCode == null ? "select ID, FILENAME from " + table + " where YEARVAR = " + year + " order by FILENAME desc" : "select ID, FILENAME from " + table + " where YEARVAR = " + year + " and GROUPVAR like '" + groupCode + "'" + " order by FILENAME desc");
        try {
            Statement statement = this.dbConnection.createStatement();
            ResultSet rs = statement.executeQuery(stmtStr);
            listEntries = new ArrayList<DocEntry>();
            while (rs.next()) {
                DocEntry entry = new DocEntry(rs.getString(2), rs.getInt(1));
                listEntries.add(entry);
            }
            statement.close();
            this.dbConnection.commit();
        }
        catch (SQLException sqle) {
            DataAccessObject.printSQLException(sqle);
        }
        return listEntries;
    }

    public boolean editRecord(String table, int id, DocumentObject record) {
        boolean bEdited = false;
        int index = this.getTableIndex(table);
        try {
            this.stmtUpdateExistingRecord[index].clearParameters();
            this.stmtUpdateExistingRecord[index].clearParameters();
            this.stmtUpdateExistingRecord[index].setString(1, record.getURL().toString());
            this.stmtUpdateExistingRecord[index].setString(2, record.getTitle());
            this.stmtUpdateExistingRecord[index].setString(3, record.getAuthors());
            this.stmtUpdateExistingRecord[index].setString(4, record.getNotes());
            this.stmtUpdateExistingRecord[index].setString(5, record.getFileName());
            this.stmtUpdateExistingRecord[index].setInt(6, id);
            this.stmtUpdateExistingRecord[index].executeUpdate();
            this.dbConnection.commit();
            bEdited = true;
        }
        catch (SQLException sqle) {
            DataAccessObject.printSQLException(sqle);
        }
        return bEdited;
    }

    public boolean deleteRecord(String table, int id) {
        boolean bDeleted = false;
        int index = this.getTableIndex(table);
        try {
            this.stmtDeleteRecord[index].clearParameters();
            this.stmtDeleteRecord[index].setInt(1, id);
            this.stmtDeleteRecord[index].executeUpdate();
            this.dbConnection.commit();
            bDeleted = true;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return bDeleted;
    }

    public DocumentObject getFileOject(String table, int id) {
        DocumentObject docObj = null;
        int index = this.getTableIndex(table);
        try {
            this.stmtGetRecord[index].clearParameters();
            this.stmtGetRecord[index].setInt(1, id);
            ResultSet result = this.stmtGetRecord[index].executeQuery();
            if (result.next()) {
                int year = result.getInt("YEARVAR");
                int dcn = result.getInt("DCN");
                int rev = result.getInt("REV");
                String group = result.getString("GROUPVAR");
                String title = result.getString("TITLE");
                String authors = result.getString("AUTHORS");
                Date uploadDate = new Date(result.getTimestamp("UPLOADDATE").getTime());
                String url = result.getString("URL");
                String notes = result.getString("NOTES");
                docObj = new DocumentObject(id, year, dcn, rev, group, title, authors, uploadDate, url, notes);
            }
            this.dbConnection.commit();
        }
        catch (ParseException ex) {
        }
        catch (MalformedURLException ex) {
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return docObj;
    }

    public static void printSQLException(SQLException e) {
        UI.LOGGER.log(Level.SEVERE, e.getMessage());
        while (e != null) {
            System.err.println("\n----- SQLException -----");
            System.err.println("  SQL State:  " + e.getSQLState());
            System.err.println("  Error Code: " + e.getErrorCode());
            System.err.println("  Message:    " + e.getMessage());
            e = e.getNextException();
        }
    }

    private int getTableIndex(String table) {
        for (int i = 0; i < this.tables.length; ++i) {
            if (!this.tables[i].equals(table)) continue;
            return i;
        }
        return -1;
    }
}

