/*
 * Decompiled with CFR 0.152.
 */
package com.drawmetry.dociimentor;

import com.drawmetry.dociimentor.Configuration;
import com.drawmetry.dociimentor.DocEntry;
import com.drawmetry.dociimentor.DocumentObject;
import com.drawmetry.dociimentor.Downloader;
import com.drawmetry.dociimentor.Exporter;
import com.drawmetry.dociimentor.FilterDialog;
import com.drawmetry.dociimentor.LogHandler;
import com.drawmetry.dociimentor.Synchronizer;
import com.drawmetry.dociimentor.database.DataAccessObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class UI
extends JFrame
implements Runnable,
ClipboardOwner {
    private static final String revision = "Revision 1.2.1 (2012-03-12)";
    private static final ResourceBundle messageBundle = ResourceBundle.getBundle("com/drawmetry/dociimentor/resources/MessageBundle");
    private static final String DATABASE_LOCATION = messageBundle.getString("DATABASE LOCATION");
    private static final String ENTRY_NOT_FOUND_IN_DATABASE = messageBundle.getString("ENTRY NOT FOUND IN DATABASE");
    private static final String NO_ENTRY_SELECTED = messageBundle.getString("NO ENTRY SELECTED");
    private static final String ENTRIES_EXPORTED_TO = messageBundle.getString("ENTRIES EXPORTED TO");
    private static final String EXCEL = messageBundle.getString("EXCEL");
    private static final String DOES_NOT_EXIST = messageBundle.getString("DOES NOT EXIST");
    private static final String DATABASE_URL = messageBundle.getString("DATABASE URL");
    private static final String FILTER = messageBundle.getString("FILTER");
    private static final String FILTER_TOOL_TIP_TEXT = messageBundle.getString("FILTER TOOL TIP TEXT");
    private static final String LATEST = messageBundle.getString("LATEST");
    private static final String SYNCHRONIZE = messageBundle.getString("SYNCHRONIZE");
    private static final String SYNCHRONIZE_TOOL_TIP_TEXT = messageBundle.getString("SYNCHRONIZE TOOL TIP TEXT");
    private static final String DOWNLOAD = messageBundle.getString("DOWNLOAD");
    private static final String DOWNLOAD_TOOL_TIP_TEXT = messageBundle.getString("DOWNLOAD TOOL TIP TEXT");
    private static final String EXPORT = messageBundle.getString("EXPORT");
    private static final String EXPORT_TOOL_TIP_TEXT = messageBundle.getString("EXPORT TOOL TIP TEXT");
    private static final String ALL_YEARS = messageBundle.getString("ALL YEARS");
    private static final String ALL_GROUPS = messageBundle.getString("ALL GROUPS");
    private static final String DOWNLOAD_NOW_Q = messageBundle.getString("DOWNLOAD NOW Q");
    private static final String ABOUT = messageBundle.getString("ABOUT");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String[] workingGroups = Configuration.getWorkingGroupNames();
    public static final Logger LOGGER = Logger.getLogger("com.drawmetry.dociimentor");
    private DataAccessObject db;
    private Configuration.WorkingGroup workingGroup;
    private String[] yearArray;
    private String yearStr = ALL_YEARS;
    private String[] groupArray;
    private String groupStr = ALL_GROUPS;
    private boolean changed = false;
    private boolean latest = false;
    private DocumentListener documentChangeListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            UI.this.changed = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            UI.this.changed = true;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            UI.this.changed = true;
        }
    };
    private DocEntry currentEntry = null;
    private String dateString;
    private boolean syncLock = false;
    private FilterDialog filterDialog;
    private List<DocEntry> allEntries;
    private List<DocEntry> latestEntries;
    private Downloader downLoader;
    private Synchronizer synchronizer;
    private JMenuItem aboutMenuItem;
    private JTextArea authorsArea;
    private JMenuItem copyDocId;
    private JMenuItem copyFileNameMenuItem;
    private JMenuItem copyURL;
    private JMenuItem copyUrlMenuItem;
    private JFormattedTextField dateTextField;
    private JMenuItem deleteEntry;
    private JMenuItem deleteEntryMenuItem;
    private JMenuItem deleteFile;
    private JMenuItem deleteFileMenuItem;
    private JTabbedPane docTabPane;
    private JList documentList;
    private JButton downloadButton;
    private JProgressBar downloadProgressBar;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JButton exportButton;
    private JMenu fileMenu;
    private JTextArea fileNameArea;
    private JButton filterButton;
    private JComboBox groupComboBox;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JCheckBox latestCheckBox;
    private JTextArea notesArea;
    private JMenuItem openMenuItem;
    private JTextArea outputArea;
    private JPopupMenu popupMenu;
    private JButton stopButton;
    private JButton synchronizeButton;
    private JComboBox workingGroupComboBox;
    private JComboBox yearComboBox;

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.copyDocId = new JMenuItem();
        this.copyURL = new JMenuItem();
        this.deleteEntry = new JMenuItem();
        this.deleteFile = new JMenuItem();
        this.jToolBar1 = new JToolBar();
        this.workingGroupComboBox = new JComboBox();
        this.jSeparator7 = new JToolBar.Separator();
        this.yearComboBox = new JComboBox();
        this.jSeparator4 = new JToolBar.Separator();
        this.groupComboBox = new JComboBox();
        this.jSeparator1 = new JToolBar.Separator();
        this.jToolBar2 = new JToolBar();
        this.latestCheckBox = new JCheckBox();
        this.jSeparator2 = new JToolBar.Separator();
        this.filterButton = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.synchronizeButton = new JButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.downloadButton = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.exportButton = new JButton();
        this.stopButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.documentList = new JList();
        this.jSplitPane2 = new JSplitPane();
        this.docTabPane = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.dateTextField = new JFormattedTextField();
        this.jScrollPane2 = new JScrollPane();
        this.fileNameArea = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.authorsArea = new JTextArea();
        this.jScrollPane5 = new JScrollPane();
        this.notesArea = new JTextArea();
        this.jScrollPane6 = new JScrollPane();
        this.outputArea = new JTextArea();
        this.downloadProgressBar = new JProgressBar();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.copyFileNameMenuItem = new JMenuItem();
        this.copyUrlMenuItem = new JMenuItem();
        this.deleteEntryMenuItem = new JMenuItem();
        this.deleteFileMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        ResourceBundle bundle = ResourceBundle.getBundle("com/drawmetry/dociimentor/resources/MessageBundle");
        this.copyDocId.setText(bundle.getString("COPY DOC ID"));
        this.copyDocId.setToolTipText("");
        this.copyDocId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.copyDocIdActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.copyDocId);
        this.copyURL.setText(bundle.getString("COPY URL"));
        this.copyURL.setToolTipText(bundle.getString("COPY THE LOCATION OF THE FILE ON THE MENTOR SERVER"));
        this.copyURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.copyURLActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.copyURL);
        this.deleteEntry.setText(bundle.getString("DELETE ENTRY"));
        this.deleteEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.deleteEntryActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.deleteEntry);
        this.deleteFile.setText(bundle.getString("DELETE FILE"));
        this.deleteFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.deleteFileActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.deleteFile);
        this.setDefaultCloseOperation(3);
        this.setTitle("Docii Mentor Edition");
        this.setMinimumSize(new Dimension(1020, 530));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                UI.this.formWindowClosing(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMaximumSize(new Dimension(400, 22));
        this.jToolBar1.setPreferredSize(new Dimension(400, 22));
        this.workingGroupComboBox.setFont(new Font("SansSerif", 0, 12));
        this.workingGroupComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.workingGroupComboBox.setMaximumSize(new Dimension(200, 20));
        this.workingGroupComboBox.setMinimumSize(new Dimension(100, 20));
        this.workingGroupComboBox.setPreferredSize(new Dimension(150, 20));
        this.workingGroupComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.workingGroupComboBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.workingGroupComboBox);
        this.jToolBar1.add(this.jSeparator7);
        this.yearComboBox.setFont(new Font("SansSerif", 0, 12));
        this.yearComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.yearComboBox.setMaximumSize(new Dimension(300, 20));
        this.yearComboBox.setMinimumSize(new Dimension(100, 20));
        this.yearComboBox.setPreferredSize(new Dimension(150, 20));
        this.yearComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.yearComboBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.yearComboBox);
        this.jToolBar1.add(this.jSeparator4);
        this.groupComboBox.setFont(new Font("SansSerif", 0, 12));
        this.groupComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.groupComboBox.setMaximumSize(new Dimension(300, 20));
        this.groupComboBox.setMinimumSize(new Dimension(100, 20));
        this.groupComboBox.setPreferredSize(new Dimension(150, 20));
        this.groupComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.groupComboBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.groupComboBox);
        this.jToolBar1.add(this.jSeparator1);
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.latestCheckBox.setFont(new Font("SansSerif", 0, 12));
        this.latestCheckBox.setText(LATEST);
        this.latestCheckBox.setFocusable(false);
        this.latestCheckBox.setHorizontalTextPosition(2);
        this.latestCheckBox.setVerticalTextPosition(3);
        this.latestCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.latestCheckBoxActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.latestCheckBox);
        this.jToolBar2.add(this.jSeparator2);
        this.filterButton.setFont(new Font("SansSerif", 0, 12));
        this.filterButton.setText(FILTER + "...");
        this.filterButton.setToolTipText(FILTER_TOOL_TIP_TEXT);
        this.filterButton.setBorder(BorderFactory.createBevelBorder(0));
        this.filterButton.setFocusable(false);
        this.filterButton.setHorizontalTextPosition(0);
        this.filterButton.setVerticalTextPosition(3);
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.filterButtonActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.filterButton);
        this.jToolBar2.add(this.jSeparator3);
        this.synchronizeButton.setFont(new Font("SansSerif", 0, 12));
        this.synchronizeButton.setText(SYNCHRONIZE);
        this.synchronizeButton.setToolTipText(SYNCHRONIZE_TOOL_TIP_TEXT);
        this.synchronizeButton.setBorder(BorderFactory.createBevelBorder(0));
        this.synchronizeButton.setFocusable(false);
        this.synchronizeButton.setHorizontalTextPosition(0);
        this.synchronizeButton.setMaximumSize(new Dimension(200, 21));
        this.synchronizeButton.setMinimumSize(new Dimension(80, 21));
        this.synchronizeButton.setPreferredSize(new Dimension(80, 21));
        this.synchronizeButton.setVerticalTextPosition(3);
        this.synchronizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.synchronizeButtonActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.synchronizeButton);
        this.jToolBar2.add(this.jSeparator5);
        this.downloadButton.setFont(new Font("SansSerif", 0, 12));
        this.downloadButton.setText(DOWNLOAD);
        this.downloadButton.setToolTipText(DOWNLOAD_TOOL_TIP_TEXT);
        this.downloadButton.setBorder(BorderFactory.createBevelBorder(0));
        this.downloadButton.setFocusable(false);
        this.downloadButton.setHorizontalTextPosition(0);
        this.downloadButton.setMaximumSize(new Dimension(200, 21));
        this.downloadButton.setMinimumSize(new Dimension(80, 21));
        this.downloadButton.setPreferredSize(new Dimension(80, 21));
        this.downloadButton.setVerticalTextPosition(3);
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.downloadButtonActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.downloadButton);
        this.jToolBar2.add(this.jSeparator6);
        this.exportButton.setFont(new Font("SansSerif", 0, 12));
        this.exportButton.setText(EXPORT);
        this.exportButton.setToolTipText(EXPORT_TOOL_TIP_TEXT);
        this.exportButton.setBorder(BorderFactory.createBevelBorder(0));
        this.exportButton.setFocusable(false);
        this.exportButton.setHorizontalTextPosition(0);
        this.exportButton.setMaximumSize(new Dimension(200, 21));
        this.exportButton.setMinimumSize(new Dimension(80, 21));
        this.exportButton.setPreferredSize(new Dimension(80, 21));
        this.exportButton.setVerticalTextPosition(3);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.exportButtonActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.exportButton);
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/com/drawmetry/dociimentor/images/stop2_32.png")));
        this.stopButton.setBorder(null);
        this.stopButton.setIconTextGap(0);
        this.stopButton.setMaximumSize(new Dimension(32, 22));
        this.stopButton.setMinimumSize(new Dimension(32, 22));
        this.stopButton.setPreferredSize(new Dimension(32, 22));
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.stopButtonActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.stopButton);
        this.jSplitPane1.setPreferredSize(new Dimension(900, 405));
        this.jPanel1.setMinimumSize(new Dimension(200, 100));
        this.jPanel1.setPreferredSize(new Dimension(200, 357));
        this.jScrollPane1.setPreferredSize(new Dimension(200, 200));
        this.documentList.setSelectionMode(0);
        this.documentList.setToolTipText(bundle.getString("DOUBLE-CLICK ON DOCUMENT"));
        this.documentList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UI.this.documentListMouseClicked(evt);
            }
        });
        this.documentList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                UI.this.documentListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.documentList);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 455, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jSplitPane2.setOrientation(0);
        this.docTabPane.setFont(new Font("Arial", 0, 18));
        this.docTabPane.setMinimumSize(new Dimension(400, 300));
        this.docTabPane.setPreferredSize(new Dimension(600, 300));
        this.dateTextField.setEditable(false);
        this.dateTextField.setHorizontalAlignment(4);
        this.dateTextField.setText("2011-02-01 23:58:30");
        this.dateTextField.setFont(new Font("SansSerif", 0, 10));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setMinimumSize(new Dimension(23, 40));
        this.jScrollPane2.setPreferredSize(new Dimension(600, 40));
        this.fileNameArea.setColumns(20);
        this.fileNameArea.setEditable(false);
        this.fileNameArea.setFont(new Font("Arial", 0, 12));
        this.fileNameArea.setLineWrap(true);
        this.fileNameArea.setRows(2);
        this.fileNameArea.setTabSize(10);
        this.fileNameArea.setToolTipText(bundle.getString("TITLE"));
        this.fileNameArea.setWrapStyleWord(true);
        this.fileNameArea.setMinimumSize(new Dimension(4, 49));
        this.jScrollPane2.setViewportView(this.fileNameArea);
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        this.jScrollPane3.setMinimumSize(new Dimension(23, 40));
        this.jScrollPane3.setPreferredSize(new Dimension(100, 40));
        this.authorsArea.setColumns(20);
        this.authorsArea.setEditable(false);
        this.authorsArea.setFont(new Font("Arial", 0, 12));
        this.authorsArea.setLineWrap(true);
        this.authorsArea.setRows(5);
        this.authorsArea.setTabSize(10);
        this.authorsArea.setToolTipText(bundle.getString("AUTHORS"));
        this.authorsArea.setWrapStyleWord(true);
        this.authorsArea.setMinimumSize(new Dimension(4, 25));
        this.jScrollPane3.setViewportView(this.authorsArea);
        this.jScrollPane5.setHorizontalScrollBarPolicy(31);
        this.jScrollPane5.setMinimumSize(new Dimension(23, 100));
        this.notesArea.setColumns(20);
        this.notesArea.setLineWrap(true);
        this.notesArea.setRows(5);
        this.notesArea.setToolTipText(bundle.getString("NOTES"));
        this.notesArea.setWrapStyleWord(true);
        this.jScrollPane5.setViewportView(this.notesArea);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(645, Short.MAX_VALUE).addComponent(this.dateTextField, -2, 129, -2)).addComponent(this.jScrollPane5, -1, 774, Short.MAX_VALUE).addComponent(this.jScrollPane3, -1, 774, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 774, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.dateTextField, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jScrollPane2, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -1, 100, Short.MAX_VALUE)));
        this.docTabPane.addTab("", this.jPanel2);
        this.jSplitPane2.setTopComponent(this.docTabPane);
        this.docTabPane.getAccessibleContext().setAccessibleName("");
        this.jScrollPane6.setVerticalScrollBarPolicy(22);
        this.jScrollPane6.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        this.jScrollPane6.setMinimumSize(new Dimension(23, 50));
        this.outputArea.setColumns(20);
        this.outputArea.setEditable(false);
        this.outputArea.setRows(5);
        this.outputArea.setToolTipText(bundle.getString("MESSAGES"));
        this.jScrollPane6.setViewportView(this.outputArea);
        this.jSplitPane2.setRightComponent(this.jScrollPane6);
        this.jSplitPane1.setRightComponent(this.jSplitPane2);
        this.fileMenu.setText(bundle.getString("FILE MENU"));
        this.fileMenu.setActionCommand(bundle.getString("FILE MENU"));
        this.openMenuItem.setText(bundle.getString("OPEN DOC"));
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.exitMenuItem.setText(bundle.getString("EXIT"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.editMenu.setText(bundle.getString("EDIT MENU"));
        this.copyFileNameMenuItem.setText(bundle.getString("COPY DOC ID"));
        this.copyFileNameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.copyDocIdActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyFileNameMenuItem);
        this.copyUrlMenuItem.setText(bundle.getString("COPY URL"));
        this.copyUrlMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.copyURLActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyUrlMenuItem);
        this.deleteEntryMenuItem.setText(bundle.getString("DELETE ENTRY"));
        this.deleteEntryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.deleteEntryActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deleteEntryMenuItem);
        this.deleteFileMenuItem.setText(bundle.getString("DELETE FILE"));
        this.deleteFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.deleteFileMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deleteFileMenuItem);
        this.jMenuBar1.add(this.editMenu);
        this.helpMenu.setText(bundle.getString("HELP MENU"));
        this.helpMenuItem.setText(bundle.getString("HELP"));
        this.helpMenuItem.setEnabled(false);
        this.helpMenu.add(this.helpMenuItem);
        this.aboutMenuItem.setText(bundle.getString("ABOUT"));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UI.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.downloadProgressBar, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 503, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar2, -2, -1, -2)).addComponent(this.jSplitPane1, -1, 988, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE).addComponent(this.jToolBar2, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 457, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadProgressBar, -2, -1, -2)));
        this.pack();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new UI());
    }

    @Override
    public void run() {
        this.initComponents();
        LOGGER.addHandler(new LogHandler(this.outputArea));
        this.db = new DataAccessObject();
        LOGGER.log(Level.INFO, "{0}: {1}\n", new Object[]{DATABASE_LOCATION, this.getDb().getDatabaseLocation()});
        LOGGER.log(Level.INFO, "{0}: {1}\n", new Object[]{DATABASE_URL, this.getDb().getDatabaseUrl()});
        if (this.db.connect()) {
            this.initComponentsContinued();
            this.setVisible(true);
        } else {
            System.exit(1);
        }
    }

    private void initComponentsContinued() {
        BufferedImage icon = null;
        try {
            Class<?> c = this.getClass();
            URL iconURL = c.getResource("images/consensii.png");
            if (iconURL != null) {
                icon = ImageIO.read(iconURL);
            } else {
                System.err.println("Cannot load logo.");
            }
        }
        catch (IOException ex) {
            System.err.println("Cannot load logo.");
        }
        if (icon != null) {
            this.setIconImage(icon);
        }
        this.stopButton.setEnabled(false);
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        this.workingGroupComboBox.setModel(new DefaultComboBoxModel<String>(workingGroups));
        this.workingGroupComboBox.setSelectedIndex(0);
        this.documentList.setCellRenderer(new DocEntryRenderer());
        this.documentList.setSelectionMode(0);
        this.documentList.addMouseListener(new PopupListener(this.popupMenu));
        this.fileNameArea.getDocument().addDocumentListener(this.documentChangeListener);
        this.authorsArea.getDocument().addDocumentListener(this.documentChangeListener);
        this.notesArea.getDocument().addDocumentListener(this.documentChangeListener);
    }

    public Configuration.WorkingGroup getWorkingGroup() {
        return this.workingGroup;
    }

    public String getYear() {
        return this.yearStr;
    }

    public String getGroup() {
        return this.groupStr;
    }

    private void selectWorkingGroup(int i) {
        assert (0 <= i && i < workingGroups.length);
        this.workingGroup = Configuration.getWorkingGroup(workingGroups[i]);
        this.yearArray = this.workingGroup.getYears();
        this.yearComboBox.setModel(new DefaultComboBoxModel<String>(this.yearArray));
        this.yearComboBox.setSelectedIndex(0);
        this.yearStr = (String)this.yearComboBox.getSelectedItem();
        this.groupArray = this.workingGroup.getGroupNames();
        this.groupComboBox.setModel(new DefaultComboBoxModel<String>(this.groupArray));
        this.groupComboBox.setSelectedIndex(0);
        this.groupStr = (String)this.groupComboBox.getSelectedItem();
        this.filterDialog = new FilterDialog(this, true);
        this.filter();
        this.updateDocumentList();
    }

    private void documentListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        DocEntry entry = (DocEntry)this.documentList.getSelectedValue();
        if (this.changed && this.currentEntry != null) {
            this.save(this.currentEntry);
        }
        this.changed = false;
        this.currentEntry = entry;
        if (entry != null) {
            int id = entry.getId();
            DocumentObject docObj = this.getDb().getFileOject(this.workingGroup.getTable(), id);
            if (docObj != null) {
                this.fillDocumentFields(docObj);
            } else {
                this.clearDocumentFields();
            }
        } else {
            this.clearDocumentFields();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDown();
    }

    private void closeDown() {
        if (this.changed && this.currentEntry != null) {
            this.save(this.currentEntry);
        }
        this.getDb().disconnect();
    }

    private void documentListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() != 2) {
            return;
        }
        this.openCurrentDocument();
    }

    private void openCurrentDocument() {
        int answer;
        if (this.currentEntry == null) {
            return;
        }
        DocumentObject docObj = this.getDb().getFileOject(this.workingGroup.getTable(), this.currentEntry.getId());
        assert (docObj != null);
        String fileName = docObj.getFileName();
        assert (fileName != null);
        File file = new File(Configuration.getDirectory(fileName), fileName);
        if (!file.exists() && (answer = JOptionPane.showConfirmDialog(this, DOWNLOAD_NOW_Q, DOWNLOAD, 0)) == 0) {
            Downloader dl = new Downloader(this);
            dl.downloadNow(docObj);
            this.documentList.repaint();
        }
        if (file.exists()) {
            try {
                file = file.getCanonicalFile();
                Desktop.getDesktop().open(file);
            }
            catch (NullPointerException ex) {
                LOGGER.log(Level.SEVERE, "{0}\n", ex.getMessage());
            }
            catch (UnsupportedOperationException ex) {
                LOGGER.log(Level.SEVERE, "{0}\n", ex.getMessage());
            }
            catch (SecurityException ex) {
                LOGGER.log(Level.SEVERE, "{0}\n", ex.getMessage());
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "{0}\n", ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.SEVERE, "{0} {1}.\n", new String[]{fileName, DOES_NOT_EXIST});
            }
        }
    }

    private void filter() {
        String yearCode = null;
        if (!this.yearStr.equals(ALL_YEARS)) {
            yearCode = this.yearStr;
        }
        String groupCode = null;
        if (!this.groupStr.equals(ALL_GROUPS)) {
            groupCode = this.workingGroup.getGroupNameToCodeMap().get(this.groupStr);
        }
        this.allEntries = this.db.findEntries(this.workingGroup.getTable(), yearCode, groupCode);
    }

    private void filterButtonActionPerformed(ActionEvent evt) {
        this.filterDialog.setVisible(true);
        this.allEntries = this.filterDialog.getEntries();
        this.updateDocumentList();
    }

    private void yearComboBoxActionPerformed(ActionEvent evt) {
        String newYear = (String)this.yearComboBox.getSelectedItem();
        if (newYear != null && !newYear.equals(this.yearStr)) {
            this.yearStr = newYear;
            this.filter();
            this.updateDocumentList();
        }
    }

    private void groupComboBoxActionPerformed(ActionEvent evt) {
        String newGroup = (String)this.groupComboBox.getSelectedItem();
        if (newGroup != null && !newGroup.equals(this.groupStr)) {
            this.groupStr = newGroup;
            this.filter();
            this.updateDocumentList();
        }
    }

    private void synchronizeButtonActionPerformed(ActionEvent evt) {
        if (!this.isSyncLock()) {
            this.setSyncLock(true);
            this.synchronizer = new Synchronizer(this, this.workingGroup.getHostUrl(), this.workingGroup.getPath(), this.buildQuery());
            Thread syncThread = new Thread(this.synchronizer);
            syncThread.start();
        }
        this.filter();
        this.updateDocumentList();
    }

    private void latestCheckBoxActionPerformed(ActionEvent evt) {
        List<DocEntry> entries;
        this.latest = this.latestCheckBox.isSelected();
        DocEntry entry = this.getSelectedListEntry();
        int id = -1;
        if (entry != null) {
            id = entry.getId();
        }
        this.refreshListEntries();
        List<DocEntry> list = entries = this.latest ? this.latestEntries : this.allEntries;
        if (entries.isEmpty()) {
            return;
        }
        if (id != -1) {
            for (int index = 0; index < entries.size(); ++index) {
                if (entries.get(index).getId() != id) continue;
                this.setSelectedIndex(index);
                return;
            }
        }
        this.setSelectedIndex(0);
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        if (!this.isSyncLock()) {
            this.setSyncLock(true);
            this.downLoader = new Downloader(this);
            Thread downloadThread = new Thread(this.downLoader);
            downloadThread.start();
            this.stopButton.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportButtonActionPerformed(ActionEvent evt) {
        FileOutputStream fileOut = null;
        try {
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(EXCEL, "xls");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                String fileName = file.getName();
                String path = file.getParent();
                int pos = fileName.lastIndexOf(".");
                if (!"xls".equals(fileName.substring(pos + 1))) {
                    fileName = fileName + ".xls";
                    file = new File(path, fileName);
                }
                fileOut = new FileOutputStream(file);
                new Exporter(this).write(fileOut);
                LOGGER.log(Level.INFO, "{0} {1}.\n", new Object[]{ENTRIES_EXPORTED_TO, file.getAbsolutePath()});
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0}\n", ex.getMessage());
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void workingGroupComboBoxActionPerformed(ActionEvent evt) {
        if (this.changed && this.currentEntry != null) {
            this.save(this.currentEntry);
        }
        this.documentList.clearSelection();
        int i = this.workingGroupComboBox.getSelectedIndex();
        this.selectWorkingGroup(i);
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        if (this.isSyncLock()) {
            this.stopButton.setEnabled(false);
            if (this.downLoader != null) {
                this.downLoader.setAbort(true);
                this.downloadButton.setEnabled(false);
            }
            if (this.synchronizer != null) {
                this.synchronizer.setAbort(true);
                this.synchronizeButton.setEnabled(false);
            }
        }
    }

    private void deleteEntryActionPerformed(ActionEvent evt) {
        int selectedIndex = this.documentList.getSelectedIndex();
        if (selectedIndex >= 0) {
            ListModel model = this.documentList.getModel();
            this.currentEntry = (DocEntry)model.getElementAt(selectedIndex);
            if (this.currentEntry != null) {
                this.db.deleteRecord(this.getTable(), this.currentEntry.getId());
                this.allEntries.remove(this.currentEntry);
                if (this.latestEntries != null) {
                    this.latestEntries.remove(this.currentEntry);
                }
                this.updateDocumentList();
            }
        }
    }

    private void copyURLActionPerformed(ActionEvent evt) {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        if (this.currentEntry != null) {
            int id = this.currentEntry.getId();
            DocumentObject obj = this.db.getFileOject(this.getTable(), id);
            if (obj != null) {
                StringSelection selection = new StringSelection(obj.getURL().toString());
                clipboard.setContents(selection, this);
            }
        }
    }

    private void copyDocIdActionPerformed(ActionEvent evt) {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        if (this.currentEntry != null) {
            int id = this.currentEntry.getId();
            DocumentObject obj = this.db.getFileOject(this.getTable(), id);
            if (obj != null) {
                StringSelection selection = new StringSelection(obj.getDocumentId());
                clipboard.setContents(selection, this);
            }
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        System.setProperty("awt.useSystemAAFontSettings", "on");
        final JEditorPane editorPane = new JEditorPane();
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        editorPane.setFont(new Font("Arial", 1, 13));
        editorPane.setPreferredSize(new Dimension(520, 180));
        editorPane.setEditable(false);
        editorPane.setContentType("text/html");
        editorPane.setText("<html><body><table border='0px' cxellpadding='10px' height='100%'><tr><td valign='center'><img src=\"" + UI.class.getResource("images/consensii.png").toExternalForm() + "\">" + "</td>" + "<td align=center>" + "Docii&trade; Document Manager &ndash; " + "Mentor Edition<br>" + revision + "<br/>" + "<br/>" + "Copyright &copy; 2012 <a href=\"mailto:support@drawmetry.com\">Erik Colban</a><br>" + "All Rights Reserved Worldwide<p>" + "<br/>" + "Docii is a trademark of Consensii LLC.<br>" + "<a href=\"http://consensii.com\"><b>consensii.com</b></a><br>" + "</td>" + "</tr>" + "</table>" + "</body>" + "</html>");
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(final HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.getWindowAncestor(editorPane).setCursor(Cursor.getPredefinedCursor(12));
                            editorPane.setToolTipText(e.getURL().toExternalForm());
                        }
                    });
                } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.getWindowAncestor(editorPane).setCursor(Cursor.getDefaultCursor());
                            editorPane.setToolTipText(null);
                        }
                    });
                } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.SEVERE, "Cannot fond the browser");
                    }
                }
            }
        });
        JOptionPane.showMessageDialog(null, new JScrollPane(editorPane), ABOUT, -1);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        this.openCurrentDocument();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.closeDown();
        System.exit(0);
    }

    private void deleteFileActionPerformed(ActionEvent evt) {
        this.deleteCurrentFile();
    }

    private void deleteCurrentFile() {
        if (this.currentEntry == null) {
            return;
        }
        DocumentObject docObj = this.getDb().getFileOject(this.workingGroup.getTable(), this.currentEntry.getId());
        assert (docObj != null);
        String fileName = docObj.getFileName();
        assert (fileName != null);
        File file = new File(Configuration.getDirectory(fileName), fileName);
        if (file.exists()) {
            file.delete();
            this.documentList.repaint();
        }
    }

    private void deleteFileMenuItemActionPerformed(ActionEvent evt) {
        this.deleteCurrentFile();
    }

    private String buildQuery() {
        String query = "";
        this.yearStr = (String)this.yearComboBox.getSelectedItem();
        if (!this.yearStr.equals(ALL_YEARS)) {
            query = query + "&is_year=" + this.yearStr;
        }
        this.groupStr = (String)this.groupComboBox.getSelectedItem();
        if (!this.groupStr.equals(ALL_GROUPS)) {
            query = query + "&is_group=" + this.workingGroup.getGroupNameToCodeMap().get(this.groupStr);
        }
        return query;
    }

    private void updateDocumentList() {
        List<DocEntry> modelEntries;
        DocEntry entry = (DocEntry)this.documentList.getSelectedValue();
        int id = -1;
        if (entry != null) {
            id = entry.getId();
        }
        if (this.allEntries == null) {
            return;
        }
        this.refreshListEntries();
        List<DocEntry> list = modelEntries = this.latest ? this.latestEntries : this.allEntries;
        if (id != -1) {
            for (int index = 0; index < modelEntries.size(); ++index) {
                if (modelEntries.get(index).getId() != id) continue;
                this.setSelectedIndex(index);
                return;
            }
        }
        this.setSelectedIndex(0);
    }

    private void refreshListEntries() {
        if (this.allEntries == null) {
            System.out.println("Stop!");
        }
        if (!this.latest) {
            DocEntry[] data = this.allEntries.toArray(new DocEntry[0]);
            this.documentList.setListData(data);
            return;
        }
        this.latestEntries = new ArrayList<DocEntry>(this.allEntries.size());
        DocEntry prevEntry = null;
        for (DocEntry entry : this.allEntries) {
            int i = entry.compare(prevEntry);
            if (prevEntry == null || i > 0) {
                prevEntry = entry;
                continue;
            }
            if (i != 0) continue;
            this.latestEntries.add(prevEntry);
            prevEntry = entry;
        }
        if (prevEntry != null) {
            this.latestEntries.add(prevEntry);
        }
        DocEntry[] data = this.latestEntries.toArray(new DocEntry[0]);
        this.documentList.setListData(data);
    }

    public int getSelectedIndex() {
        return this.documentList.getSelectedIndex();
    }

    private int setSelectedIndex(int index) {
        assert (index >= -1);
        ListModel model = this.documentList.getModel();
        int size = model.getSize();
        if (index < size) {
            this.documentList.setSelectedIndex(index);
        } else {
            this.documentList.setSelectedIndex(size - 1);
            index = size - 1;
        }
        if (this.changed && this.currentEntry != null) {
            this.save(this.currentEntry);
        }
        if (model.getSize() > 0) {
            this.currentEntry = (DocEntry)model.getElementAt(index);
        }
        this.changed = false;
        return index;
    }

    public DocEntry getSelectedListEntry() {
        DocEntry entry = (DocEntry)this.documentList.getSelectedValue();
        return entry;
    }

    private void fillDocumentFields(DocumentObject fo) {
        this.dateTextField.setText(fo.getUploadDateString());
        this.fileNameArea.setText(fo.getTitle());
        this.authorsArea.setText(fo.getAuthors());
        this.notesArea.setText(fo.getNotes());
        this.docTabPane.setTitleAt(0, fo.getDocumentId().substring(12));
        this.changed = false;
    }

    private void clearDocumentFields() {
        this.dateTextField.setText("");
        this.fileNameArea.setText("");
        this.authorsArea.setText("");
        this.notesArea.setText("");
        this.docTabPane.setTitleAt(0, "");
    }

    private void save(DocEntry entry) {
        if (entry != null) {
            int id = entry.getId();
            DocumentObject oldFo = this.getDb().getFileOject(this.getTable(), id);
            if (oldFo == null) {
                LOGGER.log(Level.WARNING, "{0}.\n", ENTRY_NOT_FOUND_IN_DATABASE);
                return;
            }
            try {
                DocumentObject newFo = new DocumentObject(id, oldFo.getYear(), oldFo.getDcn(), oldFo.getRev(), oldFo.getGroupCode(), oldFo.getTitle(), oldFo.getAuthors(), oldFo.getUploadDate(), oldFo.getURL().toString(), this.notesArea.getText());
                this.getDb().editRecord(this.getTable(), id, newFo);
            }
            catch (ParseException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        } else {
            LOGGER.log(Level.WARNING, "{0}.\n", NO_ENTRY_SELECTED);
        }
    }

    public DataAccessObject getDb() {
        return this.db;
    }

    public String getToDateString() {
        return this.dateString;
    }

    public boolean isSyncLock() {
        return this.syncLock;
    }

    public void setSyncLock(boolean lock) {
        this.downloadButton.setEnabled(!lock);
        this.synchronizeButton.setEnabled(!lock);
        this.stopButton.setEnabled(lock);
        this.syncLock = lock;
        if (!lock) {
            this.filter();
            this.updateDocumentList();
        }
    }

    public List<DocumentObject> getDocsToDownload() {
        List<DocEntry> entries = this.latest ? this.latestEntries : this.allEntries;
        ArrayList<DocumentObject> docs = new ArrayList<DocumentObject>(entries.size());
        for (DocEntry e : entries) {
            docs.add(this.db.getFileOject(this.getTable(), e.getId()));
        }
        return docs;
    }

    public Map<String, String> getGroupNameToCodeMap() {
        return this.workingGroup.getGroupNameToCodeMap();
    }

    public String getTable() {
        return this.workingGroup.getTable();
    }

    public DocEntry[] getEntries() {
        return (this.latest ? this.latestEntries : this.allEntries).toArray(new DocEntry[0]);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private class DocEntryRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            DocEntry entry = (DocEntry)value;
            String fn = entry.getFileName();
            if (new File(Configuration.getDirectory(fn), fn).exists()) {
                this.setForeground(Color.BLACK);
            } else {
                this.setForeground(Color.GRAY);
            }
            this.setText(entry.getFileName());
            return this;
        }
    }

    private class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

