/*
 * Decompiled with CFR 0.152.
 */
package com.drawmetry.dociimentor;

import com.drawmetry.dociimentor.DocEntry;
import com.drawmetry.dociimentor.DocumentObject;
import com.drawmetry.dociimentor.UI;
import com.drawmetry.dociimentor.database.DataAccessObject;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PageHandler {
    private static final String[] entryString = new String[]{"<tr .*>", "<td><div class=\"date_time\">[0-9a-zA-Z\\-]+</div></td>", "<td class=\"dcn_ordinal\">(\\d+)</td>", "<td class=\"dcn_ordinal\">(\\d+)</td>", "<td class=\"dcn_ordinal\">(\\d+)</td>", "<td>(.*)</td>", "<td class=\"long\">\\s*(.*)</td>", "<td class=\"long\">(.*)</td>", "<td><div class=\"date_time\">(.*)</div></td>", "<td class=\"list_actions\"><a href=\"(.*)\">Download</a></td>", "</tr>"};
    private static final Pattern[] entryPattern = new Pattern[entryString.length];
    private static final Pattern nextOnPattern = Pattern.compile("<span class=\"next on\">Next</span>");
    private int patternIndex = 0;
    private String year;
    private String dcn;
    private String revision;
    private String groupCode;
    private String title;
    private String authors;
    private String dateTime;
    private String urlString;
    private URL url;
    private DataAccessObject db;
    private boolean nextOff = true;
    private final int maxPages;
    private int page = 0;
    private int minYear;
    private int maxYear;
    private String[] groupCodes;
    private final String table;
    private URL urlContext;
    private int numDocsOnPage = 0;

    public PageHandler(UI ui) {
        this.db = ui.getDb();
        this.minYear = ui.getWorkingGroup().getMinYears();
        this.maxYear = Math.min(ui.getWorkingGroup().getMaxYears(), new GregorianCalendar().get(1));
        this.maxPages = ui.getWorkingGroup().getMaxPages();
        this.groupCodes = ui.getWorkingGroup().getGroupCodes();
        this.table = ui.getWorkingGroup().getTable();
        this.urlContext = ui.getWorkingGroup().getHostUrl();
    }

    public void readLine(String line) {
        Matcher nextOffMatcher = nextOnPattern.matcher(line);
        if (nextOffMatcher.find()) {
            this.nextOff = false;
        }
        Matcher matcher = entryPattern[this.patternIndex].matcher(line);
        switch (this.patternIndex) {
            case 0: 
            case 1: {
                if (matcher.matches()) {
                    ++this.patternIndex;
                    break;
                }
                this.patternIndex = 0;
                break;
            }
            case 2: {
                if (matcher.matches()) {
                    this.year = matcher.group(1);
                    if (this.isGoodYear(this.year)) {
                        ++this.patternIndex;
                        break;
                    }
                }
                this.patternIndex = 0;
                break;
            }
            case 3: {
                if (matcher.matches()) {
                    this.dcn = matcher.group(1);
                    ++this.patternIndex;
                    break;
                }
                this.patternIndex = 0;
                break;
            }
            case 4: {
                if (matcher.matches()) {
                    this.revision = matcher.group(1);
                    ++this.patternIndex;
                    break;
                }
                this.patternIndex = 0;
                break;
            }
            case 5: {
                if (matcher.matches()) {
                    ++this.patternIndex;
                    break;
                }
                this.patternIndex = 0;
                break;
            }
            case 6: {
                if (matcher.matches()) {
                    this.title = matcher.group(1);
                    ++this.patternIndex;
                    break;
                }
                this.patternIndex = 0;
                break;
            }
            case 7: {
                if (matcher.matches()) {
                    this.authors = matcher.group(1);
                    ++this.patternIndex;
                    break;
                }
                this.patternIndex = 0;
                break;
            }
            case 8: {
                if (matcher.matches()) {
                    this.dateTime = matcher.group(1);
                    ++this.patternIndex;
                    break;
                }
                this.patternIndex = 0;
                break;
            }
            case 9: {
                if (matcher.matches()) {
                    this.urlString = matcher.group(1);
                    try {
                        this.url = new URL(this.urlContext, this.urlString);
                        String fileName = this.url.getPath();
                        fileName = new File(fileName).getName();
                        Matcher m = DocumentObject.FILE_NAME_PATTERN.matcher(fileName);
                        if (m.matches()) {
                            this.groupCode = m.group(7);
                            if (this.isGoodGroup(this.groupCode)) {
                                ++this.patternIndex;
                                break;
                            }
                            this.patternIndex = 0;
                            break;
                        }
                        this.patternIndex = 0;
                    }
                    catch (MalformedURLException ex) {
                        this.url = null;
                        this.patternIndex = 0;
                        UI.LOGGER.log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                this.patternIndex = 0;
                break;
            }
            case 10: {
                if (matcher.matches()) {
                    try {
                        DocumentObject doc = new DocumentObject(-1, this.year, this.dcn, this.revision, this.groupCode, this.title, this.authors, this.dateTime, new URL(this.urlContext, this.urlString).toString(), "");
                        List<DocEntry> entries = this.db.findEntries(this.table, doc.getFileName());
                        if (entries.isEmpty()) {
                            this.db.saveRecord(this.table, doc);
                            ++this.numDocsOnPage;
                        }
                    }
                    catch (ParseException ex) {
                        UI.LOGGER.log(Level.SEVERE, null, ex);
                    }
                    catch (MalformedURLException ex) {
                        UI.LOGGER.log(Level.SEVERE, null, ex);
                    }
                }
                this.patternIndex = 0;
                break;
            }
        }
    }

    public void newPage() {
        ++this.page;
        this.numDocsOnPage = 0;
        this.nextOff = true;
        this.patternIndex = 0;
    }

    public boolean done() {
        return this.nextOff || this.page >= this.maxPages;
    }

    private boolean isGoodYear(String year) {
        int y;
        block2: {
            y = 0;
            try {
                y = Integer.parseInt(year);
            }
            catch (NumberFormatException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return this.minYear <= y && y <= this.maxYear;
    }

    private boolean isGoodGroup(String groupCode) {
        assert (groupCode != null);
        boolean found = false;
        for (int i = 0; !found && i < this.groupCodes.length; ++i) {
            found = groupCode.equals(this.groupCodes[i]);
        }
        return found;
    }

    public int getNumDocsOnPage() {
        return this.numDocsOnPage;
    }

    public int getPage() {
        return this.page;
    }

    static {
        for (int i = 0; i < entryString.length; ++i) {
            PageHandler.entryPattern[i] = Pattern.compile(entryString[i]);
        }
    }
}

