/*
 * Decompiled with CFR 0.152.
 */
package com.drawmetry.dociimentor;

import com.drawmetry.dociimentor.UI;
import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class LogHandler
extends Handler {
    public static final Logger LOGGER = UI.LOGGER;
    private final JTextArea output;

    public LogHandler(JTextArea output) {
        this.output = output;
    }

    @Override
    public void publish(LogRecord record) {
        String message = record.getMessage();
        if (message != null) {
            Object[] params = record.getParameters();
            final long time = record.getMillis();
            final String msg = MessageFormat.format(message, params);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogHandler.this.output.append(MessageFormat.format("{1}", time, msg));
                }
            });
        }
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() throws SecurityException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        LOGGER.setLevel(Level.ALL);
    }
}

