/*
 * Decompiled with CFR 0.152.
 */
package com.drawmetry.dociimentor;

import com.drawmetry.dociimentor.Configuration;
import com.drawmetry.dociimentor.ConfigurationDialog;
import com.drawmetry.dociimentor.UI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javax.swing.SwingUtilities;

public class Initializer {
    private File docDir;
    private static final Logger LOGGER = Logger.getLogger("com.drawmetry.dociimentor");

    public static void main(String[] args) {
        LOGGER.setLevel(Level.ALL);
        new Initializer().checkConfigurationSettings();
        Configuration.initialize();
        SwingUtilities.invokeLater(new UI());
    }

    private void checkConfigurationSettings() {
        File file = new File(System.getProperty("user.home"));
        assert (file.exists());
        boolean configDirExists = (file = new File(file, ".dociimentor")).exists();
        if (!configDirExists) {
            configDirExists = file.mkdir();
        }
        if (!configDirExists) assert (false);
        if (!(file = new File(file, "dociiconfig.xml")).exists()) {
            ConfigurationDialog dialog = new ConfigurationDialog(null, true);
            dialog.setVisible(true);
            this.docDir = dialog.getSelectedDirectory();
            dialog.dispose();
            dialog = null;
            try {
                InputStream configInStream = this.getClass().getResourceAsStream("resources/dociiconfig.xml");
                assert (configInStream != null);
                this.filter(configInStream, file);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            catch (SecurityException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        try {
            File logFile = new File(System.getProperty("user.home"), ".dociimentor/logfile.txt");
            StreamHandler logFileHandler = new StreamHandler(new FileOutputStream(logFile), new SimpleFormatter());
            LOGGER.addHandler(logFileHandler);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Initializer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filter(InputStream streamIn, File fileOut) throws IOException {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            String lineIn;
            reader = new BufferedReader(new InputStreamReader(streamIn));
            writer = new BufferedWriter(new FileWriter(fileOut));
            while ((lineIn = reader.readLine()) != null) {
                String lineOut = lineIn.matches("\\s*<localfiles.*>\\s*") ? "    <localfiles root = \"" + this.docDir + "\">\n" : lineIn + "\n";
                writer.write(lineOut);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

