/*
 * Decompiled with CFR 0.152.
 */
package com.drawmetry.dociimentor;

import com.drawmetry.dociimentor.DocEntry;
import com.drawmetry.dociimentor.UI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class FilterDialog
extends JDialog {
    private final UI parent;
    private List<DocEntry> entries;
    private String fromDateString;
    private String toDateString;
    private ActionListener filterListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterDialog.this.okButtonActionPerformed(e);
        }
    };
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean now = true;
    private boolean fourHoursAgo = false;
    private final Map<String, String> groupNameToCodeMap;
    private JLabel authorsLabel;
    private JTextField authorsTextField;
    private JButton cancelButton;
    private JButton clearButton;
    private JRadioButton dateRadioButton;
    private JLabel fileNameLabel;
    private JTextField fileNameTextField;
    private JRadioButton fourHoursAgoRadioButton;
    private JFormattedTextField fromDateFormattedTextField;
    private JLabel fromDateLabel;
    private JLabel notesLabel;
    private JTextField notesTextField;
    private JRadioButton nowRadioButton;
    private JButton okButton;
    private JFormattedTextField toDateFormattedTextField;
    private JLabel toDateLabel;
    private ButtonGroup toDateRadioButtonGroup;

    public FilterDialog(UI parent, boolean modal) {
        super(parent, "Filter", modal);
        this.parent = parent;
        this.initComponents();
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        int year = new GregorianCalendar(TimeZone.getTimeZone("America/New_York")).get(1);
        this.fromDateString = year + "-01-01 00:00:00";
        this.fromDateFormattedTextField.setText(this.fromDateString);
        this.toDateString = year + "-12-31 23:59:59";
        this.toDateFormattedTextField.setText(this.toDateString);
        this.toDateRadioButtonGroup.add(this.nowRadioButton);
        this.toDateRadioButtonGroup.add(this.fourHoursAgoRadioButton);
        this.toDateRadioButtonGroup.add(this.dateRadioButton);
        this.dateRadioButton.setSelected(true);
        this.fileNameTextField.addActionListener(this.filterListener);
        this.authorsTextField.addActionListener(this.filterListener);
        this.notesTextField.addActionListener(this.filterListener);
        this.groupNameToCodeMap = parent.getGroupNameToCodeMap();
    }

    public List<DocEntry> getEntries() {
        return this.entries;
    }

    private void initComponents() {
        this.toDateRadioButtonGroup = new ButtonGroup();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.authorsLabel = new JLabel();
        this.authorsTextField = new JTextField();
        this.notesLabel = new JLabel();
        this.notesTextField = new JTextField();
        this.fromDateLabel = new JLabel();
        this.fromDateFormattedTextField = new JFormattedTextField();
        this.toDateLabel = new JLabel();
        this.toDateFormattedTextField = new JFormattedTextField();
        this.clearButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.nowRadioButton = new JRadioButton();
        this.fourHoursAgoRadioButton = new JRadioButton();
        this.dateRadioButton = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.fileNameLabel.setFont(new Font("SansSerif", 0, 11));
        ResourceBundle bundle = ResourceBundle.getBundle("com/drawmetry/dociimentor/resources/MessageBundle");
        this.fileNameLabel.setText(bundle.getString("FILE NAME") + ":");
        this.fileNameLabel.setMaximumSize(new Dimension(100, 15));
        this.authorsLabel.setFont(new Font("SansSerif", 0, 11));
        this.authorsLabel.setText(bundle.getString("AUTHORS") + ":");
        this.notesLabel.setFont(new Font("SansSerif", 0, 11));
        this.notesLabel.setText(bundle.getString("NOTES") + ":");
        this.fromDateLabel.setFont(new Font("SansSerif", 0, 11));
        this.fromDateLabel.setText(bundle.getString("FROM DATE") + ":");
        this.fromDateFormattedTextField.setText("2011-12-31 00:00:00");
        this.fromDateFormattedTextField.setFont(new Font("SansSerif", 0, 11));
        this.toDateLabel.setFont(new Font("SansSerif", 0, 11));
        this.toDateLabel.setText(bundle.getString("TO DATE") + ":");
        this.toDateFormattedTextField.setText("9999-99-99 23:59:59");
        this.toDateFormattedTextField.setFont(new Font("SansSerif", 0, 11));
        this.clearButton.setFont(new Font("SansSerif", 0, 11));
        this.clearButton.setText(bundle.getString("CLEAR"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.clearButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setFont(new Font("SansSerif", 0, 11));
        this.cancelButton.setText(bundle.getString("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setFont(new Font("SansSerif", 0, 11));
        this.okButton.setText(bundle.getString("OK"));
        this.okButton.setMaximumSize(new Dimension(1000, 23));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.nowRadioButton.setFont(new Font("SansSerif", 0, 11));
        this.nowRadioButton.setText(bundle.getString("NOW") + ":");
        this.nowRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.nowRadioButtonActionPerformed(evt);
            }
        });
        this.fourHoursAgoRadioButton.setFont(new Font("SansSerif", 0, 11));
        this.fourHoursAgoRadioButton.setText(bundle.getString("FOUR HOURS AGO") + ":");
        this.fourHoursAgoRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.fourHoursAgoRadioButtonActionPerformed(evt);
            }
        });
        this.dateRadioButton.setFont(new Font("SansSerif", 0, 11));
        this.dateRadioButton.setText(bundle.getString("DATE") + ":");
        this.dateRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.dateRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.notesLabel, GroupLayout.Alignment.LEADING).addComponent(this.fromDateLabel, GroupLayout.Alignment.LEADING).addComponent(this.authorsLabel, GroupLayout.Alignment.LEADING).addComponent(this.fileNameLabel, GroupLayout.Alignment.LEADING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.notesTextField, -1, 448, Short.MAX_VALUE).addComponent(this.authorsTextField, -1, 448, Short.MAX_VALUE).addComponent(this.fileNameTextField, -1, 448, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.fromDateFormattedTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.nowRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.clearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.fourHoursAgoRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dateRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toDateFormattedTextField, -2, -1, -2))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameTextField, -2, -1, -2).addComponent(this.fileNameLabel, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorsLabel, -2, 20, -2).addComponent(this.authorsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.notesLabel).addComponent(this.notesTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fromDateLabel).addComponent(this.fromDateFormattedTextField, -2, -1, -2).addComponent(this.toDateLabel).addComponent(this.nowRadioButton).addComponent(this.fourHoursAgoRadioButton).addComponent(this.dateRadioButton).addComponent(this.toDateFormattedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton, -2, -1, -2).addComponent(this.clearButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void fourHoursAgoRadioButtonActionPerformed(ActionEvent evt) {
        long toTime = System.currentTimeMillis() - 14400000L;
        this.toDateString = this.dateFormat.format(new Date(toTime));
        this.toDateFormattedTextField.setText(this.toDateString);
        this.toDateFormattedTextField.setEditable(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.now = this.nowRadioButton.isSelected();
        this.fourHoursAgo = this.fourHoursAgoRadioButton.isSelected();
        this.filter();
        this.setVisible(false);
    }

    private void filter() {
        this.fromDateString = this.fromDateFormattedTextField.getText();
        if (this.now) {
            this.toDateString = this.dateFormat.format(new Date());
        } else if (this.fourHoursAgo) {
            long toTime = System.currentTimeMillis() - 14400000L;
            this.toDateString = this.dateFormat.format(new Date(toTime));
        } else {
            this.toDateString = this.toDateFormattedTextField.getText();
        }
        String group = this.parent.getGroup();
        String groupCode = null;
        if (!group.equals("All Groups")) {
            groupCode = this.groupNameToCodeMap.get(group);
        }
        try {
            this.entries = this.parent.getDb().findEntries(this.parent.getTable(), groupCode == null ? "%" : groupCode, "%" + this.fileNameTextField.getText() + "%", "%" + this.authorsTextField.getText() + "%", "%" + this.notesTextField.getText() + "%", this.dateFormat.parse(this.fromDateString), this.dateFormat.parse(this.toDateString));
        }
        catch (ParseException ex) {
            UI.LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.fileNameTextField.setText("");
        this.authorsTextField.setText("");
        this.notesTextField.setText("");
    }

    private void nowRadioButtonActionPerformed(ActionEvent evt) {
        this.toDateString = this.dateFormat.format(new Date());
        this.toDateFormattedTextField.setText(this.toDateString);
        this.toDateFormattedTextField.setEditable(false);
    }

    private void dateRadioButtonActionPerformed(ActionEvent evt) {
        GregorianCalendar toDate = new GregorianCalendar(TimeZone.getTimeZone("America/New_York"));
        this.toDateString = toDate.get(1) + "-12-31 23:59:59";
        this.toDateFormattedTextField.setText(this.toDateString);
        this.toDateFormattedTextField.setEditable(true);
    }
}

