/*
 * Decompiled with CFR 0.152.
 */
package com.drawmetry.dociimentor;

import com.drawmetry.dociimentor.DocEntry;
import com.drawmetry.dociimentor.DocumentObject;
import com.drawmetry.dociimentor.UI;
import com.drawmetry.dociimentor.database.DataAccessObject;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class Exporter {
    private static final int HEADING_ROW = 0;
    private static final int DOC_ID_COL = 0;
    private static final int GROUP_COL = 1;
    private static final int TITLE_COL = 2;
    private static final int TIME_COL = 3;
    private static final int AUTHORS_COL = 4;
    private static final int NOTES_COL = 5;
    private static final ResourceBundle messageBundle = ResourceBundle.getBundle("com/drawmetry/dociimentor/resources/MessageBundle");
    private static final String DOCUMENT = messageBundle.getString("DOCUMENT ID");
    private static final String DOC_GROUP = messageBundle.getString("DOCUMENT GROUP");
    private static final String TITLE = messageBundle.getString("TITLE");
    private static final String UPLOAD_TIME = messageBundle.getString("UPLOAD TIME");
    private static final String AUTHORS = messageBundle.getString("AUTHORS");
    private static final String NOTES = messageBundle.getString("NOTES");
    private Workbook wb;
    private DocEntry[] entries;
    private String table;
    private final DataAccessObject db;
    private final Map<String, String> groupCodeToNameMap;

    public Exporter(UI ui) {
        this.db = ui.getDb();
        this.table = ui.getTable();
        this.entries = ui.getEntries();
        this.groupCodeToNameMap = ui.getWorkingGroup().getGroupCodeToNameMap();
    }

    public void write(FileOutputStream fileOut) throws IOException {
        this.wb = new HSSFWorkbook();
        this.insertDocsSheet();
        if (fileOut == null) {
            throw new IOException("fileOut is null");
        }
        this.wb.write(fileOut);
    }

    private void insertDocsSheet() {
        Sheet sheet1 = this.wb.createSheet("docs");
        this.insertHeadingRow(sheet1);
        this.insertDataRows(sheet1, 1);
        sheet1.setColumnWidth(0, 6912);
        sheet1.setColumnWidth(1, 4096);
        sheet1.setColumnWidth(2, 10240);
        sheet1.setColumnWidth(3, 5120);
        sheet1.setColumnWidth(4, 7680);
        sheet1.setColumnWidth(5, 17920);
        sheet1.createFreezePane(0, 1);
    }

    private void insertHeadingRow(Sheet sheet1) {
        CellStyle headingStyle = this.createHeadingStyle();
        Row row = sheet1.createRow(0);
        Cell documentHeading = row.createCell(0);
        documentHeading.setCellValue(DOCUMENT);
        documentHeading.setCellStyle(headingStyle);
        Cell groupHeading = row.createCell(1);
        groupHeading.setCellValue(DOC_GROUP);
        groupHeading.setCellStyle(headingStyle);
        Cell titelHeading = row.createCell(2);
        titelHeading.setCellValue(TITLE);
        titelHeading.setCellStyle(headingStyle);
        Cell timeHeading = row.createCell(3);
        timeHeading.setCellValue(UPLOAD_TIME);
        timeHeading.setCellStyle(headingStyle);
        Cell authorsHeading = row.createCell(4);
        authorsHeading.setCellValue(AUTHORS);
        authorsHeading.setCellStyle(headingStyle);
        Cell notesHeading = row.createCell(5);
        notesHeading.setCellValue(NOTES);
        notesHeading.setCellStyle(headingStyle);
    }

    private void insertDataRows(Sheet sheet1, int startRow) {
        CellStyle autowrapStyle = this.createAutowrapStyle();
        CellStyle hlinkStyle = this.createHlinkStyle();
        CreationHelper createHelper = this.wb.getCreationHelper();
        int length = this.entries.length;
        for (int i = 0; i < length; ++i) {
            Row row = sheet1.createRow(i + startRow);
            DocumentObject docObj = this.db.getFileOject(this.table, this.entries[i].getId());
            Cell filePrefixCell = row.createCell(0);
            filePrefixCell.setCellValue(docObj.getDocumentId());
            Hyperlink link = createHelper.createHyperlink(1);
            link.setAddress(docObj.getURL().toString());
            filePrefixCell.setHyperlink(link);
            filePrefixCell.setCellStyle(hlinkStyle);
            Cell groupCell = row.createCell(1);
            String groupName = this.groupCodeToNameMap.get(docObj.getGroupCode());
            groupCell.setCellValue(groupName);
            groupCell.setCellStyle(autowrapStyle);
            Cell titleCell = row.createCell(2);
            titleCell.setCellValue(docObj.getTitle());
            titleCell.setCellStyle(autowrapStyle);
            Cell timeCell = row.createCell(3);
            timeCell.setCellValue(docObj.getUploadDateString());
            timeCell.setCellStyle(autowrapStyle);
            Cell authorsCell = row.createCell(4);
            authorsCell.setCellValue(docObj.getAuthors());
            authorsCell.setCellStyle(autowrapStyle);
            Cell notesCell = row.createCell(5);
            notesCell.setCellValue(docObj.getNotes());
            notesCell.setCellStyle(autowrapStyle);
        }
    }

    private CellStyle createHeadingStyle() {
        Font font = this.wb.createFont();
        font.setFontHeightInPoints((short)12);
        font.setFontName("Arial");
        font.setBoldweight((short)700);
        CellStyle style = this.wb.createCellStyle();
        style.setFont(font);
        style.setAlignment((short)2);
        style.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        style.setFillPattern((short)1);
        return style;
    }

    private CellStyle createAutowrapStyle() {
        Font font = this.wb.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName("Arial");
        CellStyle style = this.wb.createCellStyle();
        style.setFont(font);
        style.setAlignment((short)1);
        style.setWrapText(true);
        return style;
    }

    private CellStyle createHlinkStyle() {
        CellStyle style = this.wb.createCellStyle();
        Font font = this.wb.createFont();
        font.setUnderline((byte)1);
        font.setColor(IndexedColors.BLUE.getIndex());
        style.setFont(font);
        return style;
    }
}

