/*
 * Decompiled with CFR 0.152.
 */
package com.drawmetry.dociimentor;

import com.drawmetry.dociimentor.AllTrustingTrustManager;
import com.drawmetry.dociimentor.Configuration;
import com.drawmetry.dociimentor.DocumentObject;
import com.drawmetry.dociimentor.UI;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.SwingUtilities;

public class Downloader
implements Runnable {
    private static final ResourceBundle messageBundle = ResourceBundle.getBundle("com/drawmetry/dociimentor/resources/MessageBundle");
    private static final String DOWNLOAD_ABORTED = messageBundle.getString("DOWNLOAD ABORTED");
    private static final String STARTING_DOWNLOAD = messageBundle.getString("STARTING DOWNLOAD");
    private static final String DOWNLOAD_COMPLETE = messageBundle.getString("DOWNLOAD COMPLETE");
    private final UI gui;
    private boolean abortFlag = false;

    public Downloader(UI gui) {
        this.gui = gui;
        AllTrustingTrustManager singleManager = new AllTrustingTrustManager();
        TrustManager[] trustManagers = new X509TrustManager[]{singleManager};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustManagers, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        UI.LOGGER.log(Level.INFO, String.format("%s\n", STARTING_DOWNLOAD));
        List<DocumentObject> fileMap = this.gui.getDocsToDownload();
        Iterator<DocumentObject> i = fileMap.iterator();
        while (i.hasNext()) {
            DocumentObject doc = i.next();
            File dir = Configuration.getDirectory(doc.getFileName());
            if (!dir.isDirectory() || !new File(dir, doc.getFileName()).exists()) continue;
            i.remove();
        }
        int missingFiles = fileMap.size();
        boolean local = this.isGriffinAccessible();
        try {
            Iterator<DocumentObject> i2 = fileMap.iterator();
            while (!this.isAborted() && i2.hasNext()) {
                DocumentObject docObj = i2.next();
                UI.LOGGER.log(Level.INFO, String.format("[%d]", missingFiles));
                String fileName = docObj.getFileName();
                File dir = Configuration.getDirectory(fileName);
                this.downloadFile(docObj.getURL(), dir, docObj.getFileName(), local);
                this.gui.repaint();
                --missingFiles;
            }
            if (!this.isAborted()) {
                UI.LOGGER.log(Level.INFO, "{0}\n", DOWNLOAD_COMPLETE);
            } else {
                this.setAbort(false);
                UI.LOGGER.log(Level.INFO, "{0}\n", DOWNLOAD_ABORTED);
            }
        }
        catch (SocketException ex) {
            UI.LOGGER.log(Level.INFO, "{0}\n", DOWNLOAD_ABORTED);
        }
        this.releaseSynLock();
    }

    public synchronized boolean isAborted() {
        return this.abortFlag;
    }

    public synchronized void setAbort(boolean flag) {
        this.abortFlag = flag;
    }

    private void downloadFile(URL source, File localDirectory, String localFileName, boolean griffin) throws SocketException {
        if (griffin) {
            try {
                this.downloadFileFromGriffin(source, localDirectory, localFileName);
            }
            catch (IOException ex) {
                this.downloadFileFromMentor(source, localDirectory, localFileName);
            }
        } else {
            this.downloadFileFromMentor(source, localDirectory, localFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFileFromMentor(URL source, File localDirectory, String localFileName) throws SocketException {
        assert (localFileName != null);
        assert (localDirectory.isDirectory());
        File file = new File(localDirectory, localFileName);
        assert (!file.exists());
        BufferedInputStream inputStream = null;
        FilterOutputStream outputStream = null;
        try {
            int len;
            HttpsURLConnection con = (HttpsURLConnection)source.openConnection();
            InputStream is = con.getInputStream();
            inputStream = new BufferedInputStream(is);
            UI.LOGGER.log(Level.INFO, String.format("Copying %s...", localFileName));
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buff = new byte[32768];
            int count = 0;
            while ((len = inputStream.read(buff)) > 0) {
                ((BufferedOutputStream)outputStream).write(buff, 0, len);
                count += len;
            }
            UI.LOGGER.log(Level.INFO, String.format("%d bytes downloaded.\n", count));
        }
        catch (SocketException ex) {
            throw ex;
        }
        catch (MalformedURLException ex) {
            UI.LOGGER.log(Level.SEVERE, "{0}\n", ex.getMessage());
        }
        catch (IOException ex) {
            UI.LOGGER.log(Level.SEVERE, "Exception: {0}\n", ex.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFileFromGriffin(URL source, File localDirectory, String localFileName) throws SocketException, IOException {
        assert (localFileName != null);
        assert (localDirectory.isDirectory());
        File file = new File(localDirectory, localFileName);
        assert (!file.exists());
        BufferedInputStream inputStream = null;
        FilterOutputStream outputStream = null;
        try {
            int len;
            URL griffinSource = this.mapToGriffin(source);
            HttpURLConnection con = (HttpURLConnection)griffinSource.openConnection();
            InputStream is = con.getInputStream();
            inputStream = new BufferedInputStream(is);
            UI.LOGGER.log(Level.INFO, String.format("Downloading %s...", localFileName));
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buff = new byte[32768];
            int count = 0;
            while ((len = inputStream.read(buff)) > 0) {
                ((BufferedOutputStream)outputStream).write(buff, 0, len);
                count += len;
            }
            UI.LOGGER.log(Level.INFO, String.format("%d bytes downloaded.\n", count));
        }
        catch (SocketException ex) {
            throw ex;
        }
        catch (MalformedURLException ex) {
            UI.LOGGER.log(Level.SEVERE, "{0}\n", ex.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public void downloadNow(DocumentObject docObj) {
        URL source = docObj.getURL();
        String fileName = docObj.getFileName();
        File localDirectory = Configuration.getDirectory(fileName);
        try {
            this.downloadFile(source, localDirectory, fileName, this.isGriffinAccessible());
        }
        catch (SocketException ex) {
            UI.LOGGER.log(Level.INFO, "{0}\n", DOWNLOAD_ABORTED);
        }
    }

    private void releaseSynLock() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Downloader.this.gui.setSyncLock(false);
            }
        });
    }

    private URL mapToGriffin(URL source) throws MalformedURLException {
        String path = source.getPath();
        Pattern sourcePattern = Pattern.compile("(.*)/dcn(.*)");
        Matcher m = sourcePattern.matcher(path);
        if (m.matches()) {
            return new URL("http://griffin.event.ieee.org/docs" + m.group(1) + m.group(2));
        }
        throw new MalformedURLException();
    }

    private boolean isGriffinAccessible() {
        try {
            URL griffin = new URL("http://griffin.event.ieee.org");
            HttpURLConnection con = (HttpURLConnection)griffin.openConnection();
            con.connect();
        }
        catch (UnknownHostException ex) {
            return false;
        }
        catch (IOException ex) {
            UI.LOGGER.log(Level.SEVERE, ex.getMessage());
        }
        return true;
    }

    public static void main(String[] args) {
        Downloader dl = new Downloader(null);
        boolean local = dl.isGriffinAccessible();
        System.out.println("local = " + local);
    }
}

