/*
 * Decompiled with CFR 0.152.
 */
package com.drawmetry.dociimentor;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocumentObject
implements Comparable<DocumentObject> {
    public static final Pattern FILE_NAME_PATTERN = Pattern.compile("((\\w{2})-((\\d{2})-(\\d{4}))-(\\d{2}))-(\\w{4})-(.*)");
    public static final int FILE_PREFIX = 1;
    public static final int WG = 2;
    public static final int YR_DCN = 3;
    public static final int YEAR = 4;
    public static final int DCN = 5;
    public static final int REV = 6;
    public static final int GROUP_CODE = 7;
    public static final int REST = 8;
    private int id = -1;
    private int year;
    private int dcn;
    private int revision;
    private String groupCode;
    private String title;
    private String authors;
    private Date uploadDate;
    private URL url;
    private String fileName;
    private String notes;
    private static final DateFormat mentorDateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.US);

    public DocumentObject(int id, int year, int dcn, int rev, String groupCode, String title, String authors, Date uploadDate, String url, String notes) throws ParseException, MalformedURLException {
        this.id = id;
        this.year = year;
        this.dcn = dcn;
        this.revision = rev;
        this.groupCode = groupCode;
        this.title = title;
        this.authors = authors;
        this.uploadDate = new Date(uploadDate.getTime());
        this.url = new URL(url);
        this.fileName = this.url.getPath();
        this.fileName = new File(this.fileName).getName();
        this.notes = notes;
    }

    public DocumentObject(int id, String year, String dcn, String rev, String groupCode, String title, String authors, String uploadDate, String url, String notes) throws ParseException, MalformedURLException {
        this.id = id;
        this.year = Integer.parseInt(year);
        this.dcn = Integer.parseInt(dcn);
        this.revision = Integer.parseInt(rev);
        this.groupCode = groupCode;
        this.title = title;
        this.authors = authors;
        this.uploadDate = mentorDateFormat.parse(uploadDate);
        this.url = new URL(url);
        this.fileName = this.url.getPath();
        this.fileName = new File(this.fileName).getName();
        this.notes = notes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentObject other = (DocumentObject)obj;
        return this.url == other.url || this.url != null && this.url.equals(other.url);
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.url != null ? this.url.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(DocumentObject obj) {
        if (obj == null) {
            return 1;
        }
        return this.uploadDate.compareTo(obj.uploadDate);
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public String getNotes() {
        return this.notes;
    }

    public int getDcn() {
        return this.dcn;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getYear() {
        return this.year;
    }

    public int getRev() {
        return this.revision;
    }

    public String getGroupCode() {
        return this.groupCode;
    }

    public String getUploadDateString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        return df.format(this.uploadDate);
    }

    public Timestamp getUploadTimeStamp() {
        return new Timestamp(this.uploadDate.getTime());
    }

    public Date getUploadDate() {
        return this.uploadDate;
    }

    public String toString() {
        return String.format("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s", this.year, this.dcn, this.revision, this.groupCode, this.title, this.authors, this.fileName, this.getUploadDateString());
    }

    String getFilePrefix() {
        Matcher m = FILE_NAME_PATTERN.matcher(this.fileName);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public String getDocumentId() {
        Matcher m = FILE_NAME_PATTERN.matcher(this.fileName);
        if (m.matches()) {
            return String.format("IEEE 802.%s-%s-%s-%s-%s", m.group(2), m.group(4), m.group(5), m.group(6), m.group(7));
        }
        assert (false);
        return null;
    }

    static {
        mentorDateFormat.setTimeZone(TimeZone.getTimeZone("America/New_York"));
    }
}

