/*
 * Decompiled with CFR 0.152.
 */
package com.drawmetry.dociimentor;

import com.drawmetry.dociimentor.DocumentObject;
import java.util.regex.Matcher;

public class DocEntry {
    private String fileName;
    private int id;
    private Matcher matcher;

    public DocEntry(String fileName, int id) {
        if (id < 1) {
            throw new IllegalArgumentException("id must me greater than 0");
        }
        this.matcher = DocumentObject.FILE_NAME_PATTERN.matcher(fileName);
        if (!this.matcher.matches()) assert (false);
        this.fileName = fileName;
        this.id = id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String toString() {
        return this.id + ": " + this.fileName;
    }

    public int compare(DocEntry other) {
        String s1;
        if (other == null) {
            return 0;
        }
        Matcher m = DocumentObject.FILE_NAME_PATTERN.matcher(other.fileName);
        if (!m.matches()) {
            return 0;
        }
        String s0 = m.group(3);
        if (s0.equals(s1 = this.matcher.group(3))) {
            int rev0 = Integer.parseInt(this.matcher.group(6));
            int rev1 = Integer.parseInt(m.group(6));
            return rev0 - rev1;
        }
        return 0;
    }
}

