/*
 * Decompiled with CFR 0.152.
 */
package com.drawmetry.dociimentor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Configuration
extends DefaultHandler {
    private static File configFile;
    private String user;
    private String password;
    private String driver;
    private String derbyUrl;
    private String schema;
    private File systemHome;
    private File localFilesRoot;
    private WorkingGroup currentWorkingGroup;
    private List<WorkingGroup> workingGroups = new ArrayList<WorkingGroup>();
    private Map<String, WorkingGroup> workingGroupMap = new HashMap<String, WorkingGroup>();
    private List<DirectoryMatcher> directories;
    private static Configuration instance;
    private String database;
    private static final ResourceBundle messageBundle;
    private static final String ALL_YEARS;
    private static final String ALL_GROUPS;

    public static void main(String[] args) {
        File root = new File("D:/IEEE/docs/");
        Configuration.move(root, root);
    }

    private static void move(File root, File subdir) {
        ArrayList<DirectoryMatcher> dms = new ArrayList<DirectoryMatcher>();
        dms.add(new DirectoryMatcher("802-ec/20$1", "ec-(\\d\\d)-.+"));
        dms.add(new DirectoryMatcher("802wg$1/20$2", "(\\w\\w)-(\\d\\d)-.+"));
        for (File f : subdir.listFiles()) {
            if (f.isDirectory()) {
                Configuration.move(root, f);
                continue;
            }
            String fName = f.getName();
            boolean found = false;
            for (DirectoryMatcher dm : dms) {
                Matcher m = dm.pattern.matcher(fName);
                if (!m.matches()) continue;
                StringBuffer sb = new StringBuffer();
                m.appendReplacement(sb, dm.replacement);
                File parent = new File(root, sb.toString());
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                File destination = new File(parent, fName);
                f.renameTo(destination);
                System.out.format("%s ==> %s\n", fName, parent.getAbsoluteFile());
                found = true;
                break;
            }
            if (found) continue;
            f.renameTo(new File(root, fName));
        }
    }

    public static void initialize() {
        instance = new Configuration();
    }

    public static String[] getWorkingGroupNames() {
        String[] result = new String[Configuration.instance.workingGroups.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Configuration.instance.workingGroups.get(i).name;
        }
        return result;
    }

    public static String[] getWorkingGroupTables() {
        String[] result = new String[Configuration.instance.workingGroups.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Configuration.instance.workingGroups.get(i).table;
        }
        return result;
    }

    public static WorkingGroup getWorkingGroup(String name) {
        return Configuration.instance.workingGroupMap.get(name);
    }

    public static File getSystemHome() {
        return Configuration.instance.systemHome;
    }

    public static String getUser() {
        return Configuration.instance.user;
    }

    public static String getPassword() {
        return Configuration.instance.password;
    }

    public static String getDriver() {
        return Configuration.instance.driver;
    }

    public static String getDerbyUrl() {
        return Configuration.instance.derbyUrl;
    }

    public static String getSchema() {
        return Configuration.instance.schema;
    }

    public static String getDatabase() {
        return Configuration.instance.database;
    }

    public static Properties getProperties() {
        Properties props = new Properties();
        props.put("user", Configuration.instance.user);
        props.put("password", Configuration.instance.password);
        props.put("derby.driver", Configuration.instance.driver);
        props.put("derby.url", Configuration.instance.derbyUrl);
        props.put("derby.system.home", Configuration.instance.systemHome);
        props.put("db.name", Configuration.instance.database);
        props.put("schema", Configuration.instance.schema);
        return props;
    }

    public static File getDirectory(String fileName) {
        if (Configuration.instance.directories == null) {
            return Configuration.instance.localFilesRoot;
        }
        for (DirectoryMatcher dm : Configuration.instance.directories) {
            Matcher matcher = dm.pattern.matcher(fileName);
            if (!matcher.matches()) continue;
            StringBuffer sb = new StringBuffer();
            matcher.appendReplacement(sb, dm.replacement);
            File directory = new File(Configuration.instance.localFilesRoot, sb.toString());
            if (!directory.exists()) {
                directory.mkdirs();
            }
            return directory;
        }
        return Configuration.instance.localFilesRoot;
    }

    private Configuration() {
        configFile = new File(System.getProperty("user.home"), ".dociimentor/dociiconfig.xml");
        this.parseDocument();
    }

    private void parseDocument() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(configFile, (DefaultHandler)this);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger("com.drawmetry.dociimentor").log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger("com.drawmetry.dociimentor").log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger("com.drawmetry.dociimentor").log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!qName.equalsIgnoreCase("dociimentor")) {
            if (qName.equalsIgnoreCase("derby")) {
                this.startDerby(atts);
            } else if (qName.equalsIgnoreCase("localfiles")) {
                this.startLocalFiles(atts);
            } else if (qName.equalsIgnoreCase("sub")) {
                this.startSub(atts);
            } else if (qName.equalsIgnoreCase("workinggroup")) {
                this.startWorkingGroup(atts);
            } else if (qName.equalsIgnoreCase("docgroup")) {
                this.startGroup(atts);
            } else if (qName.equalsIgnoreCase("years")) {
                this.startYears(atts);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("workinggroup")) {
            this.endWorkingGroup();
        }
    }

    private void startDerby(Attributes atts) throws SAXException {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.getQName(i).equalsIgnoreCase("user")) {
                this.user = atts.getValue(i);
                continue;
            }
            if (atts.getQName(i).equalsIgnoreCase("password")) {
                this.password = atts.getValue(i);
                continue;
            }
            if (atts.getQName(i).equalsIgnoreCase("driver")) {
                this.driver = atts.getValue(i);
                continue;
            }
            if (atts.getQName(i).equalsIgnoreCase("url")) {
                this.derbyUrl = atts.getValue(i);
                continue;
            }
            if (atts.getQName(i).equalsIgnoreCase("schema")) {
                this.schema = atts.getValue(i);
                continue;
            }
            if (atts.getQName(i).equalsIgnoreCase("systemhome")) {
                File sysHome = new File(atts.getValue(i));
                boolean success = false;
                if (!sysHome.isAbsolute()) {
                    sysHome = new File(System.getProperty("user.home"), sysHome.getPath());
                }
                if (!(success = !sysHome.exists() ? sysHome.mkdirs() : sysHome.isDirectory())) {
                    throw new SAXException(sysHome.toString() + " is not a directory");
                }
                this.systemHome = sysHome;
                continue;
            }
            if (!atts.getQName(i).equalsIgnoreCase("database")) continue;
            this.database = atts.getValue(i);
        }
    }

    private void startLocalFiles(Attributes atts) throws SAXException {
        for (int i = 0; i < atts.getLength(); ++i) {
            boolean success;
            if (!atts.getQName(i).equalsIgnoreCase("root")) continue;
            this.localFilesRoot = new File(atts.getValue(i));
            if (!this.localFilesRoot.isAbsolute()) {
                this.localFilesRoot = new File(System.getProperty("user.home"), atts.getValue(i));
            }
            if (success = !this.localFilesRoot.exists() ? this.localFilesRoot.mkdirs() : this.localFilesRoot.isDirectory()) continue;
            this.localFilesRoot = null;
            throw new SAXException(atts.getValue(i) + " is not a directory.");
        }
    }

    private void startSub(Attributes atts) throws SAXException {
        String dir = null;
        String regexp = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.getQName(i).equalsIgnoreCase("dir")) {
                dir = atts.getValue(i);
                continue;
            }
            if (!atts.getQName(i).equalsIgnoreCase("regexp")) continue;
            regexp = atts.getValue(i);
        }
        if (dir != null && regexp != null) {
            DirectoryMatcher dm = new DirectoryMatcher(dir, regexp);
            if (this.directories == null) {
                this.directories = new ArrayList<DirectoryMatcher>();
            }
            this.directories.add(dm);
        }
    }

    private void startWorkingGroup(Attributes atts) throws SAXException {
        String name = null;
        String table = null;
        String host = null;
        String path = null;
        try {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (atts.getQName(i).equalsIgnoreCase("name")) {
                    name = atts.getValue(i);
                    continue;
                }
                if (atts.getQName(i).equalsIgnoreCase("table")) {
                    table = atts.getValue(i);
                    continue;
                }
                if (atts.getQName(i).equalsIgnoreCase("host")) {
                    host = atts.getValue(i);
                    continue;
                }
                if (!atts.getQName(i).equalsIgnoreCase("path")) continue;
                path = atts.getValue(i);
            }
            URL hostUrl = new URL(host);
            this.currentWorkingGroup = new WorkingGroup(name, table, hostUrl, path);
            this.workingGroups.add(this.currentWorkingGroup);
            this.workingGroupMap.put(name, this.currentWorkingGroup);
        }
        catch (MalformedURLException ex) {
            throw new SAXException(ex);
        }
    }

    private void startGroup(Attributes atts) {
        String code = null;
        String name = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.getQName(i).equalsIgnoreCase("code")) {
                code = atts.getValue(i);
                continue;
            }
            if (!atts.getQName(i).equalsIgnoreCase("name")) continue;
            name = atts.getValue(i);
        }
        assert (code != null && code.length() == 4 && name != null);
        assert (this.currentWorkingGroup != null && this.currentWorkingGroup.groups != null);
        this.currentWorkingGroup.groups.add(new Group(code, name));
    }

    private void startYears(Attributes atts) {
        int min = 2000;
        int max = 2020;
        int pages = 100;
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.getQName(i).equalsIgnoreCase("min")) {
                this.currentWorkingGroup.minYears = Integer.parseInt(atts.getValue(i));
                continue;
            }
            if (atts.getQName(i).equalsIgnoreCase("max")) {
                this.currentWorkingGroup.maxYears = Integer.parseInt(atts.getValue(i));
                continue;
            }
            if (!atts.getQName(i).equalsIgnoreCase("pages")) continue;
            this.currentWorkingGroup.maxPages = Integer.parseInt(atts.getValue(i));
        }
    }

    private void endWorkingGroup() {
        this.currentWorkingGroup = null;
    }

    static {
        messageBundle = ResourceBundle.getBundle("com/drawmetry/dociimentor/resources/MessageBundle");
        ALL_YEARS = messageBundle.getString("ALL YEARS");
        ALL_GROUPS = messageBundle.getString("ALL GROUPS");
    }

    public static class WorkingGroup {
        private final String name;
        private final String table;
        private final URL host;
        private final String path;
        private int minYears;
        private int maxYears;
        private int maxPages;
        private final List<Group> groups;

        private WorkingGroup(String name, String table, URL host, String path) {
            assert (name != null);
            assert (table != null);
            assert (host != null);
            assert (path != null);
            this.name = name;
            this.table = table;
            this.host = host;
            this.path = path;
            this.groups = new ArrayList<Group>();
            this.minYears = 2000;
            this.maxYears = 2020;
            this.maxPages = 2;
        }

        public URL getHostUrl() {
            return this.host;
        }

        public String getPath() {
            return this.path;
        }

        public int getMinYears() {
            return this.minYears;
        }

        public int getMaxYears() {
            int yearNow = new GregorianCalendar().get(1);
            return Math.min(this.maxYears, yearNow);
        }

        public String[] getYears() {
            int max = this.getMaxYears();
            String[] result = new String[max - this.minYears + 2];
            result[0] = ALL_YEARS;
            for (int i = max; i >= this.minYears; --i) {
                result[max - i + 1] = "" + i;
            }
            return result;
        }

        public int getMaxPages() {
            return this.maxPages;
        }

        public String toString() {
            return this.name;
        }

        public String getTable() {
            return this.table;
        }

        public Map<String, String> getGroupCodeToNameMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Group g : this.groups) {
                map.put(g.code, g.name);
            }
            return map;
        }

        public Map<String, String> getGroupNameToCodeMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Group g : this.groups) {
                map.put(g.name, g.code);
            }
            return map;
        }

        public String[] getGroupNames() {
            String[] result = new String[this.groups.size() + 1];
            result[0] = ALL_GROUPS;
            for (int i = 1; i < result.length; ++i) {
                result[i] = this.groups.get(i - 1).name;
            }
            return result;
        }

        public String[] getGroupCodes() {
            String[] result = new String[this.groups.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.groups.get(i).code;
            }
            return result;
        }
    }

    private static class Group {
        private final String code;
        private final String name;

        private Group(String code, String name) {
            assert (code != null && code.length() == 4);
            assert (name != null);
            this.code = code;
            this.name = name;
        }
    }

    private static class DirectoryMatcher {
        private final String replacement;
        private final Pattern pattern;

        private DirectoryMatcher(String directory, String regexp) {
            assert (directory != null);
            this.replacement = directory;
            this.pattern = Pattern.compile(regexp);
        }
    }
}

